## 更新日志

### V6.9.2---2023/02/01

- 新增列表中的视频封面静音播放的开关选项
- 新增前台发布和前台发帖在编辑器中粘贴图片直接上传功能(拥有上传图片的用户直接可使用此功能)

- 修复会员升级可能无法显示跨级升级选项的 bug
- 修复前台发布通过外链插入的图片无法点击显示原图的 bug
- 修复默写情况下可能会出现 REST API 错误的 bug
- 修复后台健康检查可能会出现的 PHP 会话未关闭的性能错误
- 修复付费界面中会员价格可能会错位的 bug
- 修复搜索功能置顶搜索词语不能输入空格的 bug
- 修复一个中危 XSS 漏洞

### V6.9---2022/12/10

- 新增前台投稿设置图片封面、幻灯片封面、视频封面的功能及用户权限管理选项
- 新增论坛帖子图片封面、幻灯片封面、视频封面的功能及用户权限管理选项
- 新增前台投稿、发帖在编辑器上传图片时候支持批量上传功能
- 新增前台投稿、发帖在编辑器选择插入图片时支持按顺序插入的功能
- 新增前台用户上传图片、上传视频大小限制的权限管理，可以细分的设置不同类型、不同会员、不同等级的用户可以上传多大文件
- 新增 wp 自带登录备用地址功能，通过此地址可以直接访问 wp 自带的登录页面，避免出现关闭登录注册后管理员无法登录后台的情况
- 新增已支付接口扫码支付兼容模式功能，部分修改版易支付接口可以开启此项进行扫码支付
- 新增前台屏蔽附件页面的功能，提高文件安全性
- 新增文章列表显示视频封面功能，在文章列表自动预览视频，更符合现代化程序体验
- 新增封面图像也能点击显示图像灯箱的功能
- 新增认证公众号接入微信登录后支持非网站扫码新关注消息自动回复功能

- 重写数据库索引，优化数据库查询速度，数据超过 5 万后有明显的提升
- 优化部分数据的储存、获取、缓存的逻辑，提高运行效率
- 优化当自己发的文章下自己的评论有回复时不会则不再通知，以免重复通知
- 优化外链重定向功能，修复当链接十分复杂的时候可能会无法正常跳转的 bug
- 优化百度社交账号登录后的头像显示，更换新的百度头像地址，避免有时候无法显示的 bug
- 优化部分 UI 细节和操作逻辑
- 修复一个支付时可能会出现多次扣费的核心的逻辑错误
- 修复未认证公众号登录输入验证码后按回车键无法登录的 bug
- 修复后台在某些情况下使用板块筛选无法显示帖子的 bug
- 修复极少情况下可能社交登录回调会出现异常的 bug
- 修复点赞、收藏等按钮可能会出现重复队列的 bug
- 修复用户列表小工具模块可能会显示重复用户的 bug
- 修复搜索栏的热门文章可能会将未发布的内容显示出来的 bug
- 修复搜索功能的默认搜索类型可能会失效的 bug

### V6.8---2022/11/02

- 新增第三方账号登录：接入彩虹聚合登录的功能
- 重新设计用户中心-账户安全页面
- 新增微信公众号登录：订阅号、未认证公众号也能使用扫码登录的功能
- 新增单独关闭新用户账号密码注册的功能，可以登录不能注册新用户
- 新增单独关闭账号密码登录的功能，只能使用社交账号进行登录
- 新增开启免密登录后则只能使用免密登录的功能（只能通过短信或邮箱验证码进行登录）
- 新增点击登录按钮默认优先弹出微信扫码登录的功能

- 修复部分情况下使用社交账号登录后会导致页面重定向不正确的 bug
- 修复部分时候可能会出现关注与被关注会重复显示的 bug
- 修复商城客户服务功能不能选择 SVG 图标的 bug
- 修复搜索功能的默认搜索类型某些情况下失效的 bug
- 修复手动赋予徽章和收回徽章功能某些情况系会失效的 bug
- 修复开启导航栏幻灯片后可能会遮挡独立登录页面的 bug

### V6.7---2022/10/10

- 新增徽章功能
- 新增消息系统自动清理过期已读消息的功能及选项，支持自定义过期时间和清理的消息类型
- 付费会员新增关闭月费会员升级月费会员的选项设置
- 图片灯箱功能新增全屏显示功能
- 首页栏目的更多栏目新增设置排序方式的选项
- 新增用户权限【查看评论】，方便设置哪些用户组可以查看评论
- 新增前台投稿、发帖页面的侧边栏顶部和侧边栏底部的布局容器，方便在此处添加小工具模块
- 新增系统弹窗的显示策略功能，可设置登录不显示、会员不显示、认证用户不显示
- 新增后台管理员直接修改用户绑定的手机号功能

- 优化阅读量的储存和获取逻辑，提高执行效率，同时避免出现因文章删除等变动导致的上级数据不准的问题
- 优化用户升级经验值以及积分的数据获取逻辑，全部切换到 ajax 请求挂钩，提高页面加载速度
- 优化热门搜索和历史搜索保存时，会同时保存搜索类型
- 优化购买会员、升级会员的弹窗显示逻辑，修复某些情况向会显示空白内容的 bug
- 修复当 wp 安装在二级目录时，有些功能会出现错误的 bug
- 修复作者页面的收藏栏目使用数字翻页时候可能会无法显示的 bug
- 修复使用缓存后移除分区版主不能自动刷新的 bug
- 修复某些情况下可能会出现手机号重复注册的 bug

### V6.6.1

- 修复商品销量浮动功能失效的 bug
- 修复右侧悬浮按钮的会员按钮可能无法正常打开的 bug
- 修复热门帖子会重复发消息的 bug

### V6.6

- 全新设计了用户中心 UI 样式，移动端更加符合现代化软件风格
- 新增帖子付费功能只隐藏部分内容的功能及配置选项
- 新增用户中心侧边栏顶部和底部小工具模块容器
- 分类页面新增是否显示文章数量的选项
- 社区帖子新增后台设置阅读量的功能
- 新增用户进入网站一定时候后自动自动弹出登录窗口的功能
- 新增文章页面相关文章设置排序方式的功能
- 新增推广返佣功能在用户中心显示自己推荐的用户明细的功能及选项
- 新增搜索功能关键词仅匹配标题的功能及选项
- 优化热门帖子、热门版块的判断逻辑，热门帖子判断新增评分限制

- 优化前台编辑文章的数据储存逻辑，避免出现再后台设置的参数被移除的 bug
- 优化支付功能的逻辑校验，避免出现金额为负数的 bug
- 修复回答被采纳不会发送消息和邮件的 bug
- 修复帖子和版块成为热门后不会发送消息的 bug
- 修复回答被采纳后不会增加积分和经验值的 bug
- 修复框架 cdn 加速的 bootcdn 接口无法使用的 bug

### V6.5.2

- 修复一个积分支付、余额支付可能会出现的漏洞
- 修复讯虎接口和微信官方接口可能会出现微信 APP 无法发起支付的 bug
- 修复某些环境下无法投票的 bug
- 修复个人主页收藏文章有时候无法翻页的 bug

### V6.5

- 新增卡密充值功能
- 新增邀请码注册功能
- 新增第三方账号首次登录后用户可选择绑定或者新建账号的页面及功能选项
- 新增微信公众号模板消息推送功能
- 新增 seo 搜索引擎图片爬取优化功能
- 新增论坛链接 URL 自动添加.html 后缀功能

- 优化第三方社交账号登录出错的页面显示样式，更加美观符合整体风格
- 优化帖子列表模块开启仅显示当前版块内容时也能在帖子页面显示
- 优化论坛帖子列表中的内容摘要显示逻辑，避免出现多余的空白行
- 优化有新的评论通知作者时候，作者非管理员则不显示 IP 地址
- 优化给管理员的邮件通知逻辑，现在会给所有管理员身份的用户发送对应邮件
- 修复评论 AJAX 自动翻页功能失效的 bug
- 修复极少情况下可能会出现自动获取的列表缩略图与实际内容不一致的 bug
- 修复后台商品统计中的有效收款金额少计算了余额充值的 bug
- 优化 PC 扫码支付界面可能会出现看不清的情况
- 优化用户最后登录时间记录方式，调整为记录每天首次登录网站时间
- 优化图文封面模块的阴影效果，当添加透明图像时有更好的显示效果
- 修复付费下载商品属性过多的时候会出现错位的 bug
- 修复社区论坛版块分类部分排序方式失效的 bug

### V6.4

- 新增论坛有新的帖子待审核时像拥有权限的版主发送消息和邮件的功能
- 新增移动端底部 tab 按钮：开通会员按钮
- 新增是否开启经典编辑器的浮动工具栏的选项(主题设置-扩展功能)
- 新增后台评论表格中也显示评论图片、表情、代码的功能
- 新增前台投稿和前台发帖限制标题字数的配置选项
- 新增发帖选择版块时候可按照版块分类进行选择的功能

- 优化免登陆购买不显示余额支付
- 优化后台主题配置的导出导入功能，修复某些情况可能会导入失败的 bug
- 优化订单金额逻辑函数，修复由于 php 浮点计算精度问题导致的无法发起支付的 bug
- 修复了收藏内容太多的时候可能会显示不全的 bug
- 修复隐藏内容中的链接可能无法点击的 bug
- 修复了移动端底部 TAB 的按钮可能会错误的 bug
- 修复海报分享显示的标题可能会乱码的 bug
- 修复发布帖子开启人机验证后无法提交的 bug
- 修复后台商城数据统计部分数据可能会错误的 bug
- 修复签到可能会出现多次累计积分的 bug
- 修复虎皮椒 v3 支付可能会无法正确跳转的 bug
- 修复一个可能由并发引起的严重漏洞

- 优化框架文件 cdn 中 bootcdn 的地址为新地址
- 修复古藤堡文章块中的阅读量、点赞量显示错误的 bug

### V6.3

- 新增创作分成系统：用户发布付费文章、付费帖子参与收入分成功能
- 新增余额支付系统：用户可充值并使用余额支付功能
- 支付功能新增新增设置使用积分支付的功能
- 新增用户积分功能
- 新增用户签到功能
- 新增提现设置手续费功能
- 新增提现时自定义提现金额的功能
- 新增普通用户免费资源每日限制下载次数的功能
- 新增腾讯云智能验证功能，极大的提高网站安全性
- 新增极验行为验 V4 人机验证接口
- 超级嵌入模块和古藤堡超级嵌入块新增是否允许全屏的选项
- 虎皮椒接口新增微信 H5 支付，新增自定义接口地址
- 新增讯虎 pay 支付宝 2.0WAP 接口
- 新增微信 JSSDK 分享功能，解决微信 app 内分享没有图片的问题
- 新增私信功能发送的私信对方未读标签显示
- 手机底部 tab 在付费文章中新增购买按钮
- 百度资源提交新增分类、标签、版块、帖子、帖子标签、帖子话题、版块分区自动提交
- 新增前台投稿后用户可修改或删除文章的权限管理
- 新增前台投稿允许发布付费内容的权限管理
- 新增论坛发帖允许发布付费内容的权限管理
- 前台发文章、发帖新增输入图片地址插入图片的功能
- 前台发文章、发帖新增查看并选择我上传的图片的功能
- 前台发文章、发帖新增输入视频地址插入视频的功能
- 前台发文章、发帖新增查看并选择我上传的视频的功能
- 前台发文章、发帖新增插入嵌入视频的功能及权限管理
- 新增后台推送消息可指定选择用户进行推送
- 新增消息功能未读消息数量显示自动更新功能
- 优化支付流程和相关逻辑，体验更优雅
- 优化图形验证码功能和滑动验证功能，增加加密 token，有效的提高网站安全性
- 优化前端编辑器，试配夜间深色主题，优化按钮逻辑
- 优化论坛、用户中心、个人中心的 TAB 链接逻辑，每个 TAB 均有独立页面，且路由链接同步
- 优化编辑器控件的显示逻辑，避免移动端显示不全的问题
- 讯虎 pay 支付接口更新支付宝 2.0 接口（还在用 1.0 的讯虎支付宝的请联系讯虎客服升级）
- 修复论坛帖子的评分用户明细可能无法显示的 bug
- 修复发布文章、帖子时候可能会重复发布的 bug
- 修复版主列模块的管理版主按钮可能会出错的 bug
- 修复了个人主页收藏文章可能会显示不全的 bug
- 修复编辑评论后可能会出现显示错乱的 bug
- 优化了大量的显示样式以及细节优化

- 修复了由于服务器环境差异可能会导致网站图标不显示的 bug
- 修复帖子页面添加模块可能会重复显示的 bug
- 修复用户主页版主身份可能会显示错误的 bug
- 修复文章目录树在侧栏随动下无法展开的 bug

### V6.2

- 新增发帖或投稿在编辑器上传视频的功能及权限管理选项
- 新增版块查看权限功能及权限管理选项
- 新增论坛首页管理员查看所有待审核帖子的 tab 栏目
- 新增将帖子评论手动设置为神评的功能及权限管理选项

- 短信宝短信接口新增 ApiKey 参数，更新接口更加高效安全
- 兼用 WP5.9

- 修复 WP5.9.1 版本下文章幻灯片模块显示不正确的 bug
- 修复 WP5.9.1 版本下底部页脚的 LOGO 尺寸错误的 bug
- 修复版块页面更多菜单按钮显示不全的 bug
- 修复会员专属资源未登录用户点击后可能会出现卡死的 bug
- 修复全局弹窗功能可能会出现报错的 bug
- 修复免费资源可能会出现报错的 bug
- 修复文章内有折叠模块时，文章目录可能无法正确定位的 bug
- 修复外链重定向到带参数的网址时候可能会出错的 bug
- 修复付费资源的链接为带参数的网址时可能会出错的 bug
- 修复支付弹窗的微信支付宝 logo 不显示的 bug
- 修复封面图 Alt 会将副标题 span 标签加入的 bug
- 修复个人信息模块按钮 2 选择错误的 bug

- 优化由于 jsdelivr CDN 在 2 月起国内访问异常导致的后台变慢的问题
- 优化发布文章发布帖子的跳转逻辑

### V6.1

- 全新的论坛系统功能
- 新增用户身份认证功能
- 新增用户等级功能
- 新增移动端底部 Tab 导航功能
- 新增讯虎 pay 支付接口的自定义网关地址功能
- 新增右侧浮动按钮：页面滚动时隐藏功能
- 新增右侧浮动按钮：显示当前页面二维码的按钮
- 全新的用户中心页面
- 全新的个人主页页面（作者页面）
- 新增消息中心页面、用户中心页面链接 URL 别名设置功能
- 新增搜索用户、文章、帖子、版块类型选择的功能
- 新增微信公众号自动回复功能
- 新增微信公众号配置自定义菜单功能
- 新增微信公众号登录：微信 app 内自动请求登录功能
- 新增 API 内容审核功能
- 新增自定义 VIP 会员图标功能
- 经典编辑器(前台编辑器)增加隐藏内容的按钮
- 前台编辑器优化上传图片按钮以及操作逻辑
- 经典编辑器(前台编辑器)增加 4 种引言样式按钮
- 新增分享功能：复制链接功能

- 优化微信企业支付：JSAPI 支付不再依赖公众号登录功能
- 优化搜索框通过 AJAX 获取，减少 sql 查询次数 6-12 次
- 优化图片上传功能的逻辑函数，提高执行效率
- 优化大量移动端 UI 以及操作方式，在移动端看上去更接近软件操作
- 优化分享功能的逻辑函数以及 UI 显示样式
- 优化了内容海报分享功能
- 优化了部分弹窗的功能以及样式
- 优化了缩略图获取逻辑，提高了执行速度，修复了自动获取略图可能会错乱的 bug

- 修复移动端用户中心绑定微信显示异常的 bug
- 修复中文用户名注册时可能会出现系统错误的 bug
- 修复消息中心未读消息翻页错误的 bug
- 彻底修复侧边随动功能偶尔会异常调动或者异常遮挡的 bug
- 修复个人主页部分评论点击后不能正确定位的 bug

- 模块全部 AJAX 调用，系统资源 0 消耗
- ajax 核心优化自动定位功能

- 标签云小工具新增论坛话题、论坛标签的选项
- 新增右侧浮动按钮：投稿、发帖、创建版块的 Add 按钮
- 新增顶部导航显示：投稿、发帖、创建版块的 Add 按钮
- 优化个人信息模块、作者信息模块，为两个模块增加设置按钮模式、按钮颜色、按钮文字的功能
- 个人信息模块新增文章类型选择的功能
- 新增设置导航栏用户卡片发布按钮
- 新增分享一键复制链接的功能
- 选项中颜色选择器增加了两个渐变预置颜色
- 评论功能新增发布、免审核、免人工审核、修改、删除的权限设置功能
- 前台投稿新增发布、免审核、免人工审核的权限设置功能
- 优化一键在线更新功能，优化授权逻辑
- 优化管理员评论不限制间隔时间
- 删除了老版本待删除的幻灯片模块

### V5.7

- 新增分类、专题自动多级筛选功能（自动显示存在的子分类）
- 新增管理员登录后会在前台显示未审核的评论，并支持前台审核或修改该评论
- 新增评论按照最新、最热的方式排序功能
- 新增评论列表 AJAX 自动加载功能及选项
- 新增站内消息数字翻页功能及选项
- 新增图片懒加载选项：其它图片选项（方便全局关闭此功能）

- 优化图片懒加载逻辑，自动判断如果是搜索引擎爬虫，则直接输出图像
- 优化全局 loading 动画，自动判断如果是搜索引擎爬虫，则不显示动画
- 优化列表数字翻页显示样式
- 优化打赏模态框显示效果，同时减少 6 次 SQL 查询
- 优化小工具模块配置的函数逻辑，添加缓存逻辑，提高速度 100%以上
- 修复私信上传图片后内容会跳到评论框的的 bug
- 修复极少情况下可能会出现小工具页面不能打开的 bug
- 修复极少情况下发送私信可能会失败的 bug

### V5.6

- 更新支持 WP5.8
- 新增社交帐号登录：代理登录功能
- 新增文章外链特色图像功能
- 新增微信公众号登录在微信 APP 内无需扫码直接登录(或绑定)的功能
- 为所有的视频模块、视频剧集模块添加固定长宽比例功能
- 新增用户中心修改手机号或修改邮箱时先验证原手机号或邮箱的功能，进一步确保账户安全
- 新增用户中心修改密码时，可使用手机或邮箱验证的功能
- 优化如果图片有链接且不是链接到原图，则直接打开链接而不会打开图片灯箱
- 优化微信企业支付 JSAPI 支付流程，无需登录也可以调用支付
- 优化讯虎支付微信 APP 内调用 JSAPI 支付流程，提高支付体验
- 新增允许用户修改自己投稿的草稿文章的功能及选项
- 新增有新的投稿待审核时向管理员发送站内消息及邮件通知的功能
- 新增百度资源推送：重新提交此链接的功能
- 新增右侧悬浮按钮：悬浮内容功能（鼠标移动到按钮显示内容）

- 新增用户修改绑定的手机号后向用户发送邮件和站内信功能
- 新增系统弹窗通知：可选炫彩标题的样式，支持 10 多种背景色彩
- 新增系统通知弹窗和用户绑定弹窗的弹窗周期设置选项
- 优化前台显示用户的手机号隐藏中间 4 位数
- 优化文章内插入的图片向左向右对齐时候的显示效果
- 优化多个 php 函数的缓存机制，提高加载效率
- 优化弹窗功能显示效果
- 优化聚合模块的热度数据获取方式

- 修复会员专属资源未登录时候点击开通会员按钮出错的 bug
- 修复微信官方支付接口在微信 APP 内支付可能会显示配置错误的 bug
- 修复用户注册时间显示不正确的 bug
- 修复开通会员原价可能会显示不正确的 bug
- 修复私信中的代码可能会显示不正确的 bug
- 修复用户登录输入邮箱可能会提示用户名过长的 bug
- 修复百度资源推送更新文章会重复提交的 bug
- 修复开启独立登录页面后扫码登录失效的 bug
- 修复展开阅读全文会会覆盖移动端菜单的 bug

### V5.5

- 新增古腾堡模块：视频剧集模块
- 新增古腾堡模块：多栏目模块
- 新增付费视频：添加付费剧集的功能
- 新增社交登录：微信公众号登录、绑定功能
- 新增是否在文章列表显示付费、分类、标签信息的选项设置（主题设置-文章列表-列表标签）
- 新增文章图片自动添加 Alt 标签功能，提高 SEO 优化
- 新增主题 SEO 功能开关，方便无需主题做 SEO 优化时候关闭主题的 SEO 功能
- 新增页面模板：zibll 文档导航
- 新增用户收到私信后给用户发送邮件通知的功能
- 新增 V 免签支付接口
- 新增码支付自定义支付接口地址的功能
- 新增微信官方接口 JSAPI 支付功能(微信 APP 内直接发起支付)

- 进一步优化 SEO 自动获取内容的逻辑，补全部分缺失的 SEO 内容，确保 google seo 评分 100
- 优化：用户名不允许为纯数字或邮箱，避免某些小概率逻辑错误
- 优化：在支付宝 APP 内支持支付宝登录
- 优化：社交登录同步检查用户名是否合法，不合法则自动创建用户名
- 优化：会员专属资源在文章列表的显示效果
- 优化：部分不支持高斯模糊的浏览器的显示效果
- 优化：图片灯箱在 IOS 系统中放大后的清晰度
- 修复：移动端列表无图模式、多图模式不生效的 bug
- 修复：未登录查看其它作者文章可能会会显示未发布的文章的 bug
- 修复：付费模块标题可能会被遮挡的 bug
- 修复：分类页面添加模块可能会重复显示的 bug
- 修复：评论回复邮件昵称显示错误的 bug

### V5.4

- 新增会员免费资源限制每日下载次数的功能(主题设置-商城付费-付费会员-会员权益)
- 付费资源新增购买权限功能，实现仅会员可购买、会员专享资源等功能
- 新增文章随机备用缩略图功能(主题设置-文章列表-备用缩略图)
- 视频文章新增视频剧集功能
- 优化大量 php 函数缓存逻辑，使用 Redis 或 Memcached 缓存后效果提升明显

- 优化图片灯箱弹出逻辑，修复部分情况下不能弹出的 bug
- 修复无侧边栏文章限制高度功能无法展开的 bug
- 修复部分浏览器下提醒消息没有背景色的 bug
- 修复部分情况下文章不显示图片的 bug
- 后台用户列表可能会显示不全的 bug
- 优化超级嵌入模块内容为异步懒加载，提高页面加载速度

### V5.3

- 新增易支付收款接口
- 图片灯箱功能单图模式增加双击缩放、移动端双指缩放功能
- 图片灯箱功能新增下载、缩放、播放功能及按钮开关
- 图片灯箱功能增加缩略图导航功能
- 优化图片灯箱双指缩放功能
- 优化图片灯箱下滑关闭功能
- 幻灯片相关模块的切换速度设置新增自动模式(根据不同设备尺寸动态设置)功能
- 新增隐藏内容-输入密码查看功能(关注微信公众号获取密码查看功能)

- 优化图像异步懒加载动画效果，避免出现长时间空白的现象

- 修复评论模块图像显示出错的 bug
- 修复幻灯片古腾堡块同时添加两个会显示出错的 bug
- 修复热榜文章模块显示时间功能无效的 bug
- 修复聚合模块可能会不显示总阅读数量的 bug
- 修复发布文章可能会出错的 bug

- 新增评论有新的回复邮件通知、站内信通知
- 新增禁止非管理员禁止进入后台的选项开关
- 新增允许 SVG 图片上传的选项，默认关闭，防止 XSS 漏洞
- 新增文章目录树显示在移动端弹出菜单内的选项开关
- 优化文章内图片异步加载功能支持第三方对象储存
- 外链重定向功能增加排除域名功能
- 修复幻灯片开启按比例自动高度后可能会出现错位的 bug
- 优化文章中插入表格的宽度自适应
- 优化外链重定向功能显示路径
- 优化大量 js 函数，提高执行效率

### V5.2

- 新增文章点赞、阅读数量初始值设置，支持设置区间随机值
- 新增小工具模块：Zibll 图标卡片(多种图标效果)
- 新增小工具模块：分类专题聚合模块(多元化显示分类及文章内容)
- 新增小工具模块：文章付费购买模块(在侧边栏显示付费文章的购买模块)

- 新增付费查看图片功能
- 新增付费查看视频功能
- 付费下载新增添加资源属性功能
- 付费下载新增添加演示地址功能
- 付费功能新增添加显示服务内容功能
- 新增付费模块显示位置设置功能
- 新增文章列表-列表缩略图靠右显示选项
- 新增文章列表-列表样式二显示
- 卡片模式的文章列表新增两种样式风格
- 新增文章列表缩略图设置图片长宽比例功能
- 幻灯片功能新增设置长宽比例保持自动高度功能
- 新增为文章设置幻灯片缩略图、幻灯片封面功能
- 新增为文章设置视频缩略图、视频封面功能

- 新增小工具模块：zibll 视频模块(支持本地视频及 m3u8、mpd、flv 等流媒体格式)
- 新增古腾堡块：zibll 视频模块(支持本地视频及 m3u8、mpd、flv 等流媒体格式)
- 新增小工具模块：zibll 超级嵌入模块(支持嵌入任意播放器及任意在线内容)
- 新增古腾堡块：zibll 超级嵌入模块(支持嵌入任意播放器及任意在线内容)

- 优化付费销量浮动功能支持区间随机值获取
- 优化古腾堡模块显示效果及部分逻辑
- 优化文章付费模块的显示效果
- 优化文章列表、文章模块显示细节及函数逻辑
- 优化部分函数执行逻辑，提高运行效率

- 修复古腾堡-提醒框块开启关闭按钮之后可能会出错的 bug
- 修复页脚微信二维码点击之后就不显示的 bug
- 修复可能会重复发送订单通知的 bug
- 修复未开启导航栏浮动时导航栏幻灯片显示不正确的 bug

- 新增小工具模块：图文封面模块
- 新增全局右侧悬浮按钮设置，支持添加、排序、独立设置等

- 优化有关左右滑动相关的模块的滑动逻辑

### V5.1.1

- 修复某些情况下页面排序按钮加载错误的 bug
- 修复百度登陆回调错误的 bug

### V5.1

- 新增用户登录/注册/找回密码页面及多项对应设置(自动生成无需设置)
- 新增默认登录为弹框或页面的选项
- 新增登录框左侧图像显示功能（支持多图随机显示）
- 新增登录框显示 LOGO 的开关选项
- 新增短信验证码登录、注册、绑定、找回密码功能
- 新增阿里云短信、腾讯云、短信宝、风吹雨短信接口
- 新增免密登录功能（验证码登录）
- 新增显示用户协议和显示隐私协议功能
- 新增用户中心绑定手机号功能
- 新增强制绑定邮箱/手机的功能
- 新增提醒用户绑定邮箱/手机的功能
- 后台用户管理新增按注册时间、最后登录、昵称、手机号排序功能
- 新增网站全局关闭用户登录/注册功能(适合无交互网站)
- 删除老版找回密码页面，由新版代替（无需任何设置）
- 删除后台选择投稿页面、选择下载页面选项（改为全自动获取，无需再手动设置）
- 优化登录注册逻辑，提交代码执行效率
- 优化登录注册人机验证逻辑
- 优化登录注册弹窗显示样式
- 优化用户中心账户安全设置相关功能
- 优化海报分享标题可能会超高覆盖内容的细节
- 优化开启缓存后海报分享图片会变得模糊的细节
- 优化搜索分类选择的显示逻辑和细节
- 优化商品会员价格判断逻辑，避免出现会员价比正常价还高的现象
- 优化全局关闭评论后同时关闭其它评论的计数图标
- 优化允许 SVG 格式图片上传
- 修复可能会重复发送订单通知的 bug
- 修复后台商城统计可能会出现时区不正确的 bug
- 修复在 php 5.6 版本会报错的 bug（仍强烈建议使用 php7 以上版本）
- 修复隐藏内容回复可见可能会失效的 bug
- 修复用户人气值和总点赞不显示的 bug

### V5.0

- 全新的推广返佣功能
- 全新的站内消息功能
- 全新的后台设置框架
- 删除列表单次加载文章数设置选项：在 wp 常规设置中设置
- 删除后台首页幻灯片功能：完全由小工具（zibll 幻灯片）模块代替
- 删除首页专题模块：完全由小工具（zibll 图文）代替
- 新增在线更新功能
- 新增导航栏幻灯片功能（代替之前首页幻灯片-显示在导航栏内的功能）
- 新增 zibll 图文小工具模块
- 新增 zibll 新版幻灯片小工具模块
- 新增图片懒加载动画选项：淡出淡入、高斯模糊、放大缩小
- 新增文章付费参数默认值设置
- 新增付费功能->设置是否显示销量的功能
- 新增前端用户提交链接后向管理员发送邮件通知功能
- 新增不同页面设置不同默认封面样式功能
- 新增不同页面设置不同 ajax 菜单功能
- 新增主题切换按钮显示位置选择(顶部导航、移动端菜单、右下角浮动按钮)
- 新增支付宝当面付 H5 支付功能（移动端跳转支付宝 APP 付款）
- 增加会员续费、升级功能，优化会员购买逻辑

- 新增文章列表 AJAX 自动加载功能

- 重写评论相关功能、优化评论上传图片细节
- 重写找回密码页面，通过验证码重设密码
- 优化大量代码逻辑，提升函数执行效率
- 优化代码高亮显示效果
- 优化 404 页面显示样式
- 优化 ajax 加载内容的逻辑，避免出现内容重叠现象
- 优化搜索选择分类的下拉菜单显示
- 代码高亮主题随系统主题实时切换
- 优化首页多栏目，支持随意添加、排序。支持分类、标签、专题选择
- 优化全局弹窗的按钮添加方式
- 优化 ajax 菜单选择方式、支持排序
- 优化文章列表卡片模式的选择分类、专题的设置方式
- 优化文章列表多图模式的选择分类设置方式
- 优化了图片灯箱功能

- 优化文章分页显示细节

- 修复可能会出现不能保存用户资料的 bug
- 修复页脚联系方式可能会显示错误的 bug
- 修复搜索页可能会报错的 bug
- 修复微信企业支付 H5 支付可能错误的 bug

### v4.2.2

修复支付宝购买不立即切换支付方式的 bug
修复支付宝当面付购买 VIP 可能存在不弹窗的 bug
修复微博登陆可能会出现错误的 bug

### v4.2

新增 页面文章排序方式按钮（主题设置-分类标签页-ajax 菜单）
新增 所有小工具标题右侧添加链接按钮功能
首页多栏目优化：
允许关闭所有栏目，即关闭整个模块
只有主栏目 1 的时候，允许标题为空
增加主栏目 1 排序方式功能及开关
优化有栏目 1 时的标题显示样式
新增 搜索功能：显示搜索历史记录关键词功能
新增 导航栏搜索框支持上滑关闭
新增 导航栏搜索框显示热门文章功能（主题设置-顶部导航-搜索功能）

新增 社交登陆：支付宝账号登录
新增 社交登陆：百度账号登录
新增 社交登陆：码云账号登录
新增 PAYJS 收款接口(个人可申请)
新增 简单易用，功能强大的讯虎 PAY 收款接口(即虎皮椒 V4，支持个人 H5 支付)

新增 SEO 预览功能，增加 SEO 优化说明
新增 菜单徽章及多样式菜单功能
新增 登录注册滑动拼图验证功能
新增 十分漂亮的 Zibll 标签云小工具模块

优化部分页面标签
优化热门搜索关键词的保存逻辑，避免出现过长较短的关键词
优化菜单手势滑动关闭偶尔不灵敏的现象

优化底部页脚的配置以及功能以显示细节
优化 SEO 自动获取细节以及配置细节
优化 wordpress 后台链接管理功能
优化文章海报分享功能，彻底解决图片跨域问题
优化前台 JS 和 CSS 代码，比 4.0 减少 40%的大小，进一步优化动态加载

修复 后台可能会出现乱码的 bug
修复 在 ipad 上不显示菜单的 bug
修复 打赏框错位的 bug

修复 虎皮椒安卓手机微信内有时候不能支付的 bug

### v4.0

修复 文章页和页面在有些情况下不闭侧边栏的 bug
修复 文章页不开启侧边栏时，古腾堡文章块显示出错的 BUG
修复 古腾堡引言块不能编辑的 bug
修复 友情链接提交模块副标题显示错误的 bug
修复 用户中心关注用户的卡片显示错位的 bug

新增 页面单独设置封面图功能：页面特色图像
新增 付费产品设置销量初始值的功能
新增 独立付费资源独立下载页面模板以及功能
新增 用户前端 ajax 方式编辑、删除评论功能(需在主题设置开启)
新增 评论用户上传图片功能(需在主题设置开启)

优化用户数据提交、储存的逻辑，减少前端代码，提高交互速度
优化前端部分 JS 函数以及 AJAX 交互逻辑，提高加载速度
优化部分内容的显示细节
优化非管理员不能进入后台

### v3.3

修复 移动端购买 vip 不能切换支付方式的 bug
修复 用户中心会向其他人显示未审核评论的 bug
修复 仅开启一级会员下，会员可见功能失效的 bug

新增 文档模式的付费功能支持
新增 链接列表 页面模板（例如友情链接）,支持链接提交、页面配置等功能
新增 新版链接列表小工具模块：采用后台链接管理系统
新增 前台登录兼用模式-主题设置-扩展功能（解决网站开启全站静态缓存后，前台可能不能弹出登录框的问题）
新增 全新的前端页面、文章配置功能，可在前端快速修改页面、文章的参数
新增 页面、文章独立设置布局的功能-前台设置
新增 4 种页面头部标题样式设置功能-前台设置
新增 页面、文章-多种前台设置功能
新增 面包屑导航用“首页”替代网站名称

优化 文章归档页面模板显示效果

### v3.1

新增全站一键关闭评论功能
新增码支付收款接口
新增会员系统：
更新百度资源提交，新增快速提交功能
付费功能新增：免费资源登录可见选项
新增全新的 隐藏内容-古腾堡块：支持评论可见、登录可见、付费可见、会员可见
优化后台发布文章也会发邮件的 bug
优化海报分享功能，支持图片跨域（使用了图片 oss 等云储存请设置跨域规则）
优化用户个人资料默认不公开
修复评论用户信息会与表情框重贴的 bug
修复非管理员进入后台会出现错误的 bug
修复支付宝付款后可能会重复发送邮件的 bug
修复文章列表显示错误以及间距不一致的 bug

修复某些情况下用户中心 404 的 bug
优化用户中心链接及资料隐藏用户名
修复文章错位的 bug
新增管理员在后台直接修改用户 会员级别和会员有效期功能（用户-修改用户资料）
修复文章图片可能会遮住文字的 bug
修复前台发布文章时上传图片出错的 bug
新增评论作者标签
新增一件关闭全站评论功能（主题设置-扩展功能）
修复前台发布文章保存可能出错的 bug
优化前台发布文章的部分细节
修复古腾堡编辑器块-文章块：可能会文章调用出错的 bug

### v2.2

调整社会化登录按钮的顺序
修复因网速过慢可能会造成幻灯片错位的 bug
修复评论内容不换行的 bug
优化社会化登录后返回原链接
修复分类页面文章数量显示错误的 bug
修复部分页面可能会出现的 OSS 漏洞以及 SQL 注入漏洞
修复用户页面存在的蜘蛛爬取空白链接的漏洞
修复页脚微信二维码跳动的 bug
修复外链重定向可能会跳转出错的 bug

新增支付宝企业支付接口以及企业 H5 支付
新增商品购买后给用户发送邮件
新增评论审核后用户发送邮件
新增投稿审核后用户发送邮件
新增邮箱验证码注册功能
新增修改用户前端修改邮箱功能
新增自定义邮件发件人昵称功能、自定义追加邮件代码功能
新增文章列表标题文字显示为粗体的选项

完全重写海报分享功能，减少 80%代码量，极大的提高了速度。（此采用 canvas 绘图，不支持图片跨域！同时由于 canvas 存在兼容性不良好的情况，再某些浏览器上可能会出现 bug，请知晓。今后会重新使用 php 方式在做一个）

首页幻灯片增加 5 种切换动画选择

更新授权逻辑，提高安全性，解决可能会掉授权的 bug

### v2.1

全新功能：支付系统、付费阅读、付费下载功能
搜索功能新增：热门关键词选项、最大关键词数量设置、搜索框默认占位符设置
全局顶部搜索框新增：自定义开关关键词显示、自定义开关分类搜索、自定义分类搜索的分类
优化后台更新逻辑，增加跳过此次更新功能
图片灯箱增加点击空白处关闭功能，同时支持下滑关闭
图片灯箱增加键盘左右键切换
新增文章内插入文章的古腾堡块

优化社交登录获取的头像非 https 会导致的网站不安全问题
更新授权验证逻辑，修复极少情况可能出现的效验失败的 bug
优化了用户中心的显示效果

优化部分 js 文件逻辑，解决加载过慢的现象

修复搜索页文章 mini 模块编号显示错误的 bug
修复安装主题可能会出现 functions.php 的错误
修复文章海报和摘要会显示隐藏内容的 bug
修复移动端内容超出宽度导致左右滚动的 bug
修复分享到 qq 不显示标题的 bug
修复幻灯片不显示标题简介的 bug
优化移动端选择输入框的样式
更新百度资源主动推送接口，优化推送逻辑

修复小工具会显示未审核评论的 BUG
修复面包屑导航不能关闭的 bug

### v2.0

增加专题 SEO 深度优化功能，可以单独给专题设定 SEO
增加百度资源自动推送功能，无需开启熊掌号，所有连接自动提交，再次的增加了百度的收录速度
增加侧栏随动功能，添加侧边栏模块时直接可以设置（并非所有模块都适合开启，请根据实际效果开启,不建议开启太多）
提醒：侧栏随动功能，因为我想实现多模块随动。但是由于底部自定义空间太大，导致没有很好的逻辑来处理触底检测，所以目前这个功能如果你开启了太多的随动模块，可能会出现触底抖动的现象！此问题我会继续优化，建议开启的模块不要超过 3 个！

增加授权和在线更新
增加 GitHub 登录功能
增加封面图异步加载开关
添加隐藏内容 css 样式
优化：外链重定向功能将目标链接加密
增加社交帐号绑定和解绑功能
增加自定义时间格式功能
增加 logo 区分日间、夜间主题，且实时切换
增加禁止重复昵称开关功能，修改昵称不允许修改为已存在的昵称
所有的文章模块增加时间限制功能，如：最近 7 天
增加是否开启 AJAX 加载选项
增加社社交帐号按钮样式选择
优化文章内链接高亮颜色显示
优化文章内标题的显示样式
优化文章内表格的显示样式
优化大量位置的显示细节

修复移动端菜单显示错位的 BUG
修复缩略图在有些浏览器不显示的 bug
修复图片灯箱下拉关闭失效的 bug
修复社会化登录跳转 404 问题
修复文章页极少情况下文章页可能不能打开的 bug
修复前端发布文章-添加媒体的弹出框文字错位的 bug
修复 markdown 内联代码解析为块级元素的 bug
修复后台设置有两个 幻灯片图像异步加载功能
修复 AJAX 获取文章之后，幻灯片缩略图不显示的 bug
修复 昵称是否有保留字符 功能失效的 bug
修复前端登录如果密码错误则不能再点击按钮的 bug
修复评论模块时间显示不正确的 bug
修复修改昵称后可能跳转 404 的 bug
修复评论填入呢称时社交登录标题错位的 bug

### v1.0.beta3

1. 修复邮件 SMTP 设置不生效的 BUG
2. 修复缩略图在有些浏览器不显示的 bug
3. 修复移动端导航在有些浏览器不能滚动的 bug
4. 修复了部分弹窗功能不能关闭的 bug
5. 修复了部分小工具模块的设置 bug
6. 修复 WordPress 部分版本图片不居中问题
7. 修复文章列表默认排序设置不晓得的 bug
8. 增加文章格式选择，画廊和图片格式将会在文章页显示封面（确保文章有清晰度较高的图像再选择图片或者画廊）
9. 增加文章幻灯片封面功能，将文章格式设置为"画廊"将会在文章页头部显示幻灯片封面
10. 增加社交账号登录功能
11. 修复前台在某些情况下不能发布文章的 bug
12. 修复用户中心在某些情况下设置不生效的 bug
13. 修复幻灯片如果加载过会出现超宽的 bug
14. 增加简约文档模式功能
15. 新增搜索小工具
16. 重写专题功能，增加专题分类，文章类小工具可选择专题
17. 增加文章列表缩略图幻灯片功能，开启后文章格式为“画廊”的文章将显示幻灯片缩略图

### v1.0.beta2

1. 增加以下功能
   分类 url 去除 category 该功能和 no-category 插件作用相同，可停用 no-category 插件
   关闭顶部 admin_bar 开启后则不显示 WordPress 顶部黑条
   防 pingback 攻击
   删除 WordPress 自带 Emoji 表情
   禁用 Google 字体
   清理多于的头部 Meta 标签
   上传文件重命名上传文件自动重命名为随机英文名
   禁止 WordPress 检测更新
   禁用古腾堡编辑器
2. 增加幻灯片小工具功能，现在可以可视化在页面也和地方添加幻灯片了
3. 首页幻灯片增加自动高度功能
4. 增加文章多栏目小工具和文章多栏目 mini 小工具
5. 增加最近评论小工具
6. 增加邮件 SMTP 服务功能
7. 前端发布文章增加允许上传图片的选项
8. 增加用户列表小工具
9. 增加首页文章排除功能
10. 增加链接列表小工具
11. 增加公告栏小工具
12. 增加两个小工具位置：所有页面顶部位置、所有页面底部位置
13. 增加系统通知弹窗功能
14. 优化了主题切换逻辑，增加按钮显示开关
15. 修复菜单显示 bug
16. 修复若干 bug
17. 增加移动端触摸滑动关闭菜单
18. 优化幻灯片显示效果和代码逻辑
19. 优化图片灯箱代码逻辑（请将图片链接到媒体文件）
